from django.contrib import admin

# Register your models here.

from api_rbs.models import InfoAcount, Orders


@admin.register(Orders)
class OrdersAdmin(admin.ModelAdmin):
    list_display = (
        "tikect_order",
        "profit_order",
        "direction",
        "fbs_lecense",
        "currency_pair",
    )  # Removido status e result
    search_fields = ("tikect_order", "direction", "order_status")
    list_filter = ("direction", "order_status", "currency_pair")


@admin.register(InfoAcount)
class InfoAcountAdmin(admin.ModelAdmin):
    list_display = (
        "fbs_lecense",
        "cross_balance",
        "net_balance",
        "open_balance",
    )
    search_fields = ("",)
    list_filter = ()
    ordering = ("-cross_balance",)