# Generated by Django 5.2.3 on 2025-06-18 17:41

import django.db.models.deletion
import django_extensions.db.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("site_rbs", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="InfoAcount",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    django_extensions.db.fields.CreationDateTimeField(
                        auto_now_add=True, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    django_extensions.db.fields.ModificationDateTimeField(
                        auto_now=True, verbose_name="modified"
                    ),
                ),
                (
                    "account_name",
                    models.CharField(
                        help_text="Name of the account",
                        max_length=255,
                        verbose_name="Account Name",
                    ),
                ),
                (
                    "cross_balance",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Total balance of the account",
                        max_digits=20,
                        verbose_name="Saldo Bruto",
                    ),
                ),
                (
                    "net_balance",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Net balance of the account",
                        max_digits=20,
                        verbose_name="Saldo Liquido",
                    ),
                ),
                (
                    "open_balance",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Initial balance of the account",
                        max_digits=20,
                        verbose_name="Saldo de Abertura",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        db_column="user_id",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="site_rbs.users",
                    ),
                ),
            ],
            options={
                "get_latest_by": "modified",
                "abstract": False,
            },
        ),
        migrations.RunSQL(
            sql="ALTER TABLE api_rbs_infoacount MODIFY user_id BIGINT UNSIGNED NOT NULL;",
            reverse_sql="ALTER TABLE api_rbs_infoacount MODIFY user_id BIGINT NOT NULL;",
        ),
        migrations.CreateModel(
            name="Orders",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    django_extensions.db.fields.CreationDateTimeField(
                        auto_now_add=True, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    django_extensions.db.fields.ModificationDateTimeField(
                        auto_now=True, verbose_name="modified"
                    ),
                ),
                (
                    "tikect_order",
                    models.CharField(
                        help_text="Unique identifier for the order",
                        max_length=255,
                        verbose_name="Ticket Order",
                    ),
                ),
                (
                    "profit_order",
                    models.CharField(
                        blank=True,
                        help_text="Profit associated with the order",
                        max_length=255,
                        null=True,
                        verbose_name="Profit Order",
                    ),
                ),
                (
                    "direction",
                    models.CharField(
                        choices=[("compra", "Buy"), ("venda", "Sell")],
                        help_text="Direction of the order (buy/sell)",
                        max_length=10,
                        verbose_name="Order Direction",
                    ),
                ),
                (
                    "oder_result",
                    models.CharField(
                        choices=[("gain", "Gain"), ("loss", "Loss")],
                        default="open",
                        help_text="Result of the order (gain/loss)",
                        max_length=10,
                        verbose_name="Order Result",
                    ),
                ),
                (
                    "order_status",
                    models.CharField(
                        choices=[("aberta", "Aberta"), ("fechada", "Fechada")],
                        default="open",
                        help_text="Status of the order (open/closed)",
                        max_length=10,
                        verbose_name="Order Status",
                    ),
                ),
                (
                    "currency_pair",
                    models.CharField(
                        blank=True,
                        help_text="Currency pair for the order (e.g., EUR/USD)",
                        max_length=10,
                        null=True,
                        verbose_name="Currency Pair",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        db_column="user_id",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="site_rbs.users",
                    ),
                ),
            ],
            options={
                "get_latest_by": "modified",
                "abstract": False,
            },
        ),
        migrations.RunSQL(
            sql="ALTER TABLE api_rbs_orders MODIFY user_id BIGINT UNSIGNED NOT NULL;",
            reverse_sql="ALTER TABLE api_rbs_orders MODIFY user_id BIGINT NOT NULL;",
        ),
        migrations.RemoveField(
            model_name="infoacount",
            name="user",
        ),
        migrations.RemoveField(
            model_name="orders",
            name="user",
        ),
        migrations.AddField(
            model_name="orders",
            name="fbs_lecense",
            field=models.ForeignKey(
                blank=True,
                help_text="Foreign key to FBS Licenses",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="site_rbs.fbslicenses",
                verbose_name="FBS License",
            ),
        ),
    ]
