from django.db import models
from django_extensions.db.models import TimeStampedModel

from utils.consts.api_rbs import OrderStatus, Direction, OrderResult


# Create your models here.


class InfoAcount(TimeStampedModel):
    """
    Model to store information about the account.
    """

    fbs_lecense = models.ForeignKey(
        "site_rbs.FbsLicenses",
        on_delete=models.CASCADE,
        verbose_name="FBS License",
        help_text="Foreign key to FBS Licenses",
        null=True,
        blank=True,
    )

    cross_balance = models.DecimalField(
        max_digits=20,
        decimal_places=2,
        default=0.00,
        verbose_name="Saldo Bruto",
        help_text="Total balance of the account",
    )

    net_balance = models.DecimalField(
        max_digits=20,
        decimal_places=2,
        default=0.00,
        verbose_name="Saldo Liquido",
        help_text="Net balance of the account",
    )
    open_balance = models.DecimalField(
        max_digits=20,
        decimal_places=2,
        default=0.00,
        verbose_name="Saldo de Abertura",
        help_text="Initial balance of the account",
    )

    def __str__(self):
        return f"{self.open_balance} - {self.net_balance if self.fbs_lecense else 'No User'}"


class Orders(TimeStampedModel):
    """
    Model to store information about orders.
    """

    fbs_lecense = models.ForeignKey(
        "site_rbs.FbsLicenses",
        on_delete=models.CASCADE,
        verbose_name="FBS License",
        help_text="Foreign key to FBS Licenses",
        null=True,
        blank=True,
    )

    tikect_order = models.CharField(
        max_length=255,
        verbose_name="Ticket Order",
        help_text="Unique identifier for the order",
    )

    profit_order = models.CharField(
        max_length=255,
        verbose_name="Profit Order",
        help_text="Profit associated with the order",
        null=True,
        blank=True,
    )
    direction = models.CharField(
        max_length=10,
        verbose_name="Order Direction",
        help_text="Direction of the order (buy/sell)",
    )
    oder_result = models.CharField(
        max_length=10,
        default="open",
        verbose_name="Order Result",
        help_text="Result of the order (gain/loss)",
    )
    order_status = models.CharField(
        max_length=10,
        choices=OrderStatus.CHOICES,
        default="open",
        verbose_name="Order Status",
        help_text="Status of the order (open/closed)",
    )

    currency_pair = models.CharField(
        max_length=10,
        verbose_name="Currency Pair",
        help_text="Currency pair for the order (e.g., EUR/USD)",
        null=True,
        blank=True,
    )

    creater_on_bot = models.DateTimeField(
        verbose_name="Created on Bot",
        help_text="Timestamp when the order was created on the bot",
        null=True,
        blank=True,
    )

    #  lot
    # Abertura
    # Fechamento

    def __str__(self):
        return (
            f"Order {self.tikect_order} - {self.fbs_lecense if self.fbs_lecense else 'No User'}"
        )
