# api_rbs/v1/serializer.py
from rest_framework import serializers

from api_rbs.models import InfoAcount, Orders
from site_rbs.models import FbsLicenses, Users


class OrdemAbertaSerializer(serializers.Serializer):
    ordemTicket = serializers.CharField()
    ordemLucro = serializers.FloatField()
    ordemHorarioAbertura = serializers.CharField(required=False, allow_null=True, allow_blank=True)
    ordemTipo = serializers.CharField(required=False, allow_null=True, allow_blank=True)
    ordemAtivo = serializers.CharField(required=False, allow_null=True, allow_blank=True)

class OrdemEncerradaSerializer(serializers.Serializer):
    ordemTicket = serializers.CharField()
    ordemLucro = serializers.FloatField()
    ordemHorarioAbertura = serializers.CharField(required=False, allow_null=True, allow_blank=True)
    ordemTipo = serializers.CharField(required=False, allow_null=True, allow_blank=True)
    ordemAtivo = serializers.CharField(required=False, allow_null=True, allow_blank=True)

class ContaSerializer(serializers.Serializer):
    nomeConta = serializers.CharField()
    numeroConta = serializers.CharField()
    saldoBruto = serializers.FloatField()
    saldoLiquido = serializers.FloatField()
    saldoAberto = serializers.FloatField()
    ordensAbertas = OrdemAbertaSerializer(many=True)
    ordensEncerradas = OrdemEncerradaSerializer(many=True)


class HomeRequestSerializer(serializers.Serializer):
   numero_conta = serializers.CharField(required=False, allow_null=True, allow_blank=True)



# Home serializers
class HomeReturnDataSerializer(serializers.ModelSerializer):
    get_licenses = serializers.SerializerMethodField()

    class Meta:
        model = InfoAcount
        fields = [
            'fbs_lecense',
            'cross_balance',
            'net_balance',
            'open_balance',
            'created',
            'modified',
            'get_licenses',
        ]

    def get_get_licenses(self, obj):
        licenses = InfoAcount.objects.filter(fbs_lecense=obj.fbs_lecense)
        data = {
           'nomeConta': obj.fbs_lecense.user.name if obj.fbs_lecense else None,
              'numeroConta': obj.fbs_lecense.user.number if obj.fbs_lecense else None
        }
        return [data]


# Serializers open orders

class OpenOrdersRequestSerializer(serializers.Serializer):
    numero_conta = serializers.CharField(required=False, allow_null=True, allow_blank=True)


class OpenOrdersReturnDataSerializer(serializers.ModelSerializer):

    class Meta:
        model = Orders
        fields = [
            'fbs_lecense',
            'tikect_order',
            'profit_order',
            'creater_on_bot',
            'direction',
            'oder_result',
            'order_status',
            'currency_pair',
            'modified',
        ]


# Serializers history orders
class HistoryOrdersRequestSerializer(serializers.Serializer):
    numero_conta = serializers.CharField(required=False, allow_null=True, allow_blank=True)

class HistoryOrdersReturnDataSerializer(serializers.ModelSerializer):

    class Meta:
        model = Orders
        fields = [
            'fbs_lecense',
            'tikect_order',
            'profit_order',
            'creater_on_bot',
            'direction',
            'oder_result',
            'order_status',
            'currency_pair',
            'modified',
        ]



# Serializer from profile user

class ProfileUserRequestSerializer(serializers.Serializer):
    numero_conta = serializers.CharField(required=False, allow_null=True, allow_blank=True)

class ProfileUserReturnDataSerializer(serializers.ModelSerializer):
    class Meta:
        model = Users
        fields = [
            'name',
            'number',
            'profile',
            'doc_number'
        ]