# consumidor MQ para a fila received-order



import os
import sys
import django
import pika
import json
import datetime
from django.utils import timezone
# Configura o Django no script
BASE_DIR = os.path.dirname(os.path.abspath(__file__))
PROJECT_DIR = os.path.dirname(BASE_DIR)  # Ajusta para o diretório correto do projeto
sys.path.append(PROJECT_DIR)
os.environ.setdefault("DJANGO_SETTINGS_MODULE", "site_api.settings")
django.setup()

from django.conf import settings

from utils.consts.api_rbs import OrderStatus



from api_rbs.models import InfoAcount, Orders
from site_rbs.models import FbsLicenses



# Importações após inicializar o Django
from api_rbs.v1.serializer import ContaSerializer


def callback(ch, method, properties, body):
    # Decodifica a mensagem recebida
    raw_body = body.decode("utf-8").rstrip("\x00")
    data = json.loads(raw_body.replace("'", '"'))

    # Serializa os dados recebidos
    serializer = ContaSerializer(data=data)
    if serializer.is_valid():
        data = serializer.validated_data
        # Salva ou processa os dados conforme necessário
        print("Dados recebidos:", data)
        fbs_licence_id = FbsLicenses.objects.filter(number=data["numeroConta"]).first()
        if fbs_licence_id:
            for ordem in data["ordensEncerradas"]:
                order, _ = Orders.objects.get_or_create(
                    fbs_lecense=fbs_licence_id,
                    tikect_order=ordem["ordemTicket"],
                )
                order.profit_order = ordem["ordemLucro"]
                order.direction = ordem["ordemTipo"]
                if ordem["ordemHorarioAbertura"]:
                    dt = datetime.datetime.strptime(
                        ordem["ordemHorarioAbertura"], "%Y.%m.%d %H:%M:%S"
                    )
                    order.creater_on_bot = timezone.make_aware(dt, timezone.get_default_timezone())

            order.currency_pair = ordem.get("ordemAtivo", None)
            order.order_status = OrderStatus.CLOSED
            order.save()

            for ordem in data["ordensAbertas"]:
                order, _ = Orders.objects.get_or_create(
                    fbs_lecense=fbs_licence_id,
                    tikect_order=ordem["ordemTicket"],
                )
                order.profit_order = ordem["ordemLucro"]
                order.direction = ordem["ordemTipo"]
                if ordem["ordemHorarioAbertura"]:
                    dt = datetime.datetime.strptime(
                        ordem["ordemHorarioAbertura"], "%Y.%m.%d %H:%M:%S"
                    )
                    order.creater_on_bot = timezone.make_aware(dt, timezone.get_default_timezone())

                order.currency_pair = ordem.get("ordemAtivo", None)
                order.order_status = OrderStatus.OPEN
                order.save()

            update_information, created = InfoAcount.objects.get_or_create(
                fbs_lecense=fbs_licence_id
            )
            print(created)

            update_information.cross_balance = data["saldoBruto"]
            update_information.net_balance = data["saldoLiquido"]
            update_information.open_balance = data["saldoAberto"]
            update_information.save()

        else:
            print(f"Febs account not found = {serializer.errors}")

    else:
        print("Erro na validação dos dados:", serializer.errors)


def start_consumer():
    # Configura a conexão com o RabbitMQ
    connection = pika.BlockingConnection(
        pika.ConnectionParameters(
            host=settings.RABBITMQ_HOST,
            port=settings.RABBITMQ_PORT,
            credentials=pika.PlainCredentials(
                settings.RABBITMQ_USER, settings.RABBITMQ_PASSWORD
            ),
        )
    )

    channel = connection.channel()
    channel.queue_declare(queue="received-order", durable=True)

    # Define o consumidor
    channel.basic_consume(
        queue="received-order", on_message_callback=callback, auto_ack=True
    )

    print('Aguardando mensagens na fila "received-order". Pressione CTRL+C para sair.')

    try:
        channel.start_consuming()
    except KeyboardInterrupt:
        print("Consumo interrompido.")
        channel.stop_consuming()
    finally:
        connection.close()


if __name__ == "__main__":
    start_consumer()
