# RabbitMQ Server Docker Setup

This project provides a simple setup for running a RabbitMQ server using Docker. Below are the instructions on how to build and run the RabbitMQ server.

## Prerequisites

- Docker installed on your machine
- Docker Compose installed

## Getting Started

1. **Clone the repository:**

   ```bash
   git clone <repository-url>
   cd rabbitmq-server
   ```

2. **Build the Docker image (if necessary):**

   If you have a custom Dockerfile and want to build the image, run:

   ```bash
   docker build -t custom-rabbitmq .
   ```

3. **Start the RabbitMQ server:**

   Use Docker Compose to start the RabbitMQ server:

   ```bash
   docker-compose up -d
   ```

   This command will start the RabbitMQ server in detached mode.

4. **Access RabbitMQ Management Interface:**

   Once the server is running, you can access the RabbitMQ management interface by navigating to:

   ```
   http://localhost:15672
   ```

   The default username and password are both `guest`.

## Stopping the Server

To stop the RabbitMQ server, run:

```bash
docker-compose down
```

## Customization

You can customize the RabbitMQ configuration by modifying the `docker-compose.yml` file and the `Dockerfile` as needed.

## License

This project is licensed under the MIT License.