# Generated by Django 5.2.3 on 2025-06-18 16:31

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Audits",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("user_type", models.CharField(blank=True, max_length=255, null=True)),
                ("user_id", models.PositiveBigIntegerField(blank=True, null=True)),
                ("event", models.CharField(max_length=255)),
                ("auditable_type", models.CharField(max_length=255)),
                ("auditable_id", models.PositiveBigIntegerField()),
                ("old_values", models.TextField(blank=True, null=True)),
                ("new_values", models.TextField(blank=True, null=True)),
                ("url", models.TextField(blank=True, null=True)),
                ("ip_address", models.CharField(blank=True, max_length=45, null=True)),
                (
                    "user_agent",
                    models.CharField(blank=True, max_length=1023, null=True),
                ),
                ("tags", models.CharField(blank=True, max_length=255, null=True)),
                ("created_at", models.DateTimeField(blank=True, null=True)),
                ("updated_at", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "db_table": "audits",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="ConfigsStore",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("title", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "emails_form",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("title_seo", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "description_seo",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("email", models.CharField(blank=True, max_length=255, null=True)),
                ("tels", models.CharField(blank=True, max_length=255, null=True)),
                ("logo", models.CharField(blank=True, max_length=255, null=True)),
                ("whatsapp", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "whatsapp_message",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("address", models.TextField(blank=True, null=True)),
                ("map_code", models.TextField(blank=True, null=True)),
                ("map_link", models.TextField(blank=True, null=True)),
                (
                    "opening_hours",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("facebook", models.CharField(blank=True, max_length=255, null=True)),
                ("instagram", models.CharField(blank=True, max_length=255, null=True)),
                ("youtube", models.CharField(blank=True, max_length=255, null=True)),
                ("twitter", models.CharField(blank=True, max_length=255, null=True)),
                ("linkedin", models.CharField(blank=True, max_length=255, null=True)),
                ("whatsapp_floating", models.IntegerField()),
                ("created_at", models.DateTimeField(blank=True, null=True)),
                ("updated_at", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "db_table": "configs_store",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="FailedJobs",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("uuid", models.CharField(max_length=255, unique=True)),
                ("connection", models.TextField()),
                ("queue", models.TextField()),
                ("payload", models.TextField()),
                ("exception", models.TextField()),
                ("failed_at", models.DateTimeField()),
            ],
            options={
                "db_table": "failed_jobs",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="FbsLicenses",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("status_license", models.IntegerField(blank=True, null=True)),
                ("validate", models.DateField(blank=True, null=True)),
                ("server", models.CharField(blank=True, max_length=255, null=True)),
                ("number", models.CharField(blank=True, max_length=255, null=True)),
                ("password", models.CharField(blank=True, max_length=255, null=True)),
                ("nickname", models.CharField(blank=True, max_length=255, null=True)),
                ("created_at", models.DateTimeField(blank=True, null=True)),
                ("updated_at", models.DateTimeField(blank=True, null=True)),
                (
                    "initial_balance",
                    models.DecimalField(
                        blank=True, decimal_places=2, max_digits=10, null=True
                    ),
                ),
            ],
            options={
                "db_table": "fbs_licenses",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="FormFields",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("uuid", models.CharField(max_length=36)),
                ("label", models.CharField(max_length=255)),
                ("name", models.CharField(max_length=255)),
                ("type", models.CharField(max_length=255)),
                ("required", models.IntegerField()),
                ("options", models.JSONField(blank=True, null=True)),
                ("order", models.IntegerField()),
                ("created_at", models.DateTimeField(blank=True, null=True)),
                ("updated_at", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "db_table": "form_fields",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="Forms",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("name", models.CharField(max_length=255)),
                ("created_at", models.DateTimeField(blank=True, null=True)),
                ("updated_at", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "db_table": "forms",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="Images",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("image", models.CharField(max_length=255, unique=True)),
                ("item_id", models.PositiveBigIntegerField(blank=True, null=True)),
                ("token", models.CharField(blank=True, max_length=256, null=True)),
                ("type", models.CharField(blank=True, max_length=100, null=True)),
                ("created_at", models.DateTimeField(blank=True, null=True)),
                ("updated_at", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "db_table": "images",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="Migrations",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("migration", models.CharField(max_length=255)),
                ("batch", models.IntegerField()),
            ],
            options={
                "db_table": "migrations",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="ModelHasPermissions",
            fields=[
                (
                    "pk",
                    models.CompositePrimaryKey(
                        "permission_id",
                        "model_id",
                        "model_type",
                        blank=True,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("model_type", models.CharField(max_length=255)),
                ("model_id", models.PositiveBigIntegerField()),
            ],
            options={
                "db_table": "model_has_permissions",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="ModelHasRoles",
            fields=[
                (
                    "pk",
                    models.CompositePrimaryKey(
                        "role_id",
                        "model_id",
                        "model_type",
                        blank=True,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("model_type", models.CharField(max_length=255)),
                ("model_id", models.PositiveBigIntegerField()),
            ],
            options={
                "db_table": "model_has_roles",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="Notifications",
            fields=[
                (
                    "id",
                    models.CharField(max_length=36, primary_key=True, serialize=False),
                ),
                ("type", models.CharField(max_length=255)),
                ("notifiable_type", models.CharField(max_length=255)),
                ("notifiable_id", models.PositiveBigIntegerField()),
                ("data", models.TextField()),
                ("read_at", models.DateTimeField(blank=True, null=True)),
                ("created_at", models.DateTimeField(blank=True, null=True)),
                ("updated_at", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "db_table": "notifications",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="PasswordResetTokens",
            fields=[
                (
                    "email",
                    models.CharField(max_length=255, primary_key=True, serialize=False),
                ),
                ("token", models.CharField(max_length=255)),
                ("created_at", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "db_table": "password_reset_tokens",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="Permissions",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("name", models.CharField(max_length=255)),
                ("guard_name", models.CharField(max_length=255)),
                ("created_at", models.DateTimeField(blank=True, null=True)),
                ("updated_at", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "db_table": "permissions",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="PersonalAccessTokens",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("tokenable_type", models.CharField(max_length=255)),
                ("tokenable_id", models.PositiveBigIntegerField()),
                ("name", models.CharField(max_length=255)),
                ("token", models.CharField(max_length=64, unique=True)),
                ("abilities", models.TextField(blank=True, null=True)),
                ("last_used_at", models.DateTimeField(blank=True, null=True)),
                ("expires_at", models.DateTimeField(blank=True, null=True)),
                ("created_at", models.DateTimeField(blank=True, null=True)),
                ("updated_at", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "db_table": "personal_access_tokens",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="RoleHasPermissions",
            fields=[
                (
                    "pk",
                    models.CompositePrimaryKey(
                        "permission_id",
                        "role_id",
                        blank=True,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
            ],
            options={
                "db_table": "role_has_permissions",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="Roles",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("name", models.CharField(max_length=255)),
                ("guard_name", models.CharField(max_length=255)),
                ("created_at", models.DateTimeField(blank=True, null=True)),
                ("updated_at", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "db_table": "roles",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="Sessions",
            fields=[
                (
                    "id",
                    models.CharField(max_length=255, primary_key=True, serialize=False),
                ),
                ("user_id", models.PositiveBigIntegerField(blank=True, null=True)),
                ("ip_address", models.CharField(blank=True, max_length=45, null=True)),
                ("user_agent", models.TextField(blank=True, null=True)),
                ("payload", models.TextField()),
                ("last_activity", models.IntegerField()),
            ],
            options={
                "db_table": "sessions",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="Users",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("name", models.CharField(max_length=255)),
                ("email", models.CharField(max_length=255, unique=True)),
                ("email_verified_at", models.DateTimeField(blank=True, null=True)),
                ("password", models.CharField(max_length=255)),
                ("two_factor_secret", models.TextField(blank=True, null=True)),
                ("two_factor_recovery_codes", models.TextField(blank=True, null=True)),
                (
                    "two_factor_confirmed_at",
                    models.DateTimeField(blank=True, null=True),
                ),
                ("status", models.IntegerField(blank=True, null=True)),
                ("role", models.CharField(max_length=255)),
                (
                    "remember_token",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                (
                    "current_team_id",
                    models.PositiveBigIntegerField(blank=True, null=True),
                ),
                (
                    "profile_photo_path",
                    models.CharField(blank=True, max_length=2048, null=True),
                ),
                ("created_at", models.DateTimeField(blank=True, null=True)),
                ("updated_at", models.DateTimeField(blank=True, null=True)),
                ("tel", models.CharField(blank=True, max_length=255, null=True)),
                ("profile", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "name_trader",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("confirmed", models.IntegerField(blank=True, null=True)),
                ("address", models.CharField(blank=True, max_length=255, null=True)),
                ("zipcode", models.CharField(blank=True, max_length=255, null=True)),
                ("city", models.CharField(blank=True, max_length=255, null=True)),
                ("state", models.CharField(blank=True, max_length=255, null=True)),
                ("doc_number", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "amount",
                    models.DecimalField(
                        blank=True, decimal_places=2, max_digits=10, null=True
                    ),
                ),
                ("date_of_birth", models.DateField(blank=True, null=True)),
                ("license_validity", models.DateField(blank=True, null=True)),
                ("status_license", models.IntegerField(blank=True, null=True)),
                ("fbs_server", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "fbs_account",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    "fbs_password",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("app_login", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "app_password",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    "enables_app_order_closure",
                    models.IntegerField(blank=True, null=True),
                ),
                (
                    "initial_investment",
                    models.DecimalField(
                        blank=True, decimal_places=2, max_digits=10, null=True
                    ),
                ),
                ("currency", models.CharField(blank=True, max_length=20, null=True)),
                ("number", models.CharField(blank=True, max_length=15, null=True)),
                ("first_save", models.IntegerField(blank=True, null=True)),
            ],
            options={
                "db_table": "users",
                "managed": False,
            },
        ),
    ]
