# This is an auto-generated Django model module.
# You'll have to do the following manually to clean this up:
#   * Rearrange models' order
#   * Make sure each model has one field with primary_key=True
#   * Make sure each ForeignKey and OneToOneField has `on_delete` set to the desired behavior
#   * Remove `managed = False` lines if you wish to allow Django to create, modify, and delete the table
# Feel free to rename the models, but don't rename db_table values or field names.
from django.db import models


class Audits(models.Model):
    id = models.BigAutoField(primary_key=True)
    user_type = models.CharField(max_length=255, blank=True, null=True)
    user_id = models.PositiveBigIntegerField(blank=True, null=True)
    event = models.CharField(max_length=255)
    auditable_type = models.CharField(max_length=255)
    auditable_id = models.PositiveBigIntegerField()
    old_values = models.TextField(blank=True, null=True)
    new_values = models.TextField(blank=True, null=True)
    url = models.TextField(blank=True, null=True)
    ip_address = models.CharField(max_length=45, blank=True, null=True)
    user_agent = models.CharField(max_length=1023, blank=True, null=True)
    tags = models.CharField(max_length=255, blank=True, null=True)
    created_at = models.DateTimeField(blank=True, null=True)
    updated_at = models.DateTimeField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = "audits"

    def __str__(self):
        return (
            f"{self.event} by {self.user_type} (ID: {self.user_id}) on {self.created_at}"
            if self.created_at
            else "Audit Log Entry"
        )


class ConfigsStore(models.Model):
    id = models.BigAutoField(primary_key=True)
    title = models.CharField(max_length=255, blank=True, null=True)
    emails_form = models.CharField(max_length=255, blank=True, null=True)
    title_seo = models.CharField(max_length=255, blank=True, null=True)
    description_seo = models.CharField(max_length=255, blank=True, null=True)
    email = models.CharField(max_length=255, blank=True, null=True)
    tels = models.CharField(max_length=255, blank=True, null=True)
    logo = models.CharField(max_length=255, blank=True, null=True)
    whatsapp = models.CharField(max_length=255, blank=True, null=True)
    whatsapp_message = models.CharField(max_length=255, blank=True, null=True)
    address = models.TextField(blank=True, null=True)
    map_code = models.TextField(blank=True, null=True)
    map_link = models.TextField(blank=True, null=True)
    opening_hours = models.CharField(max_length=255, blank=True, null=True)
    facebook = models.CharField(max_length=255, blank=True, null=True)
    instagram = models.CharField(max_length=255, blank=True, null=True)
    youtube = models.CharField(max_length=255, blank=True, null=True)
    twitter = models.CharField(max_length=255, blank=True, null=True)
    linkedin = models.CharField(max_length=255, blank=True, null=True)
    whatsapp_floating = models.IntegerField()
    created_at = models.DateTimeField(blank=True, null=True)
    updated_at = models.DateTimeField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = "configs_store"

    def __str__(self):
        return self.title if self.title else "Store Configurations"


class FailedJobs(models.Model):
    id = models.BigAutoField(primary_key=True)
    uuid = models.CharField(unique=True, max_length=255)
    connection = models.TextField()
    queue = models.TextField()
    payload = models.TextField()
    exception = models.TextField()
    failed_at = models.DateTimeField()

    class Meta:
        managed = False
        db_table = "failed_jobs"

    def __str__(self):
        return (
            f"Failed Job {self.uuid} at {self.failed_at}"
            if self.failed_at
            else "Failed Job Entry"
        )


class FbsLicenses(models.Model):
    id = models.BigAutoField(primary_key=True)
    status_license = models.IntegerField(blank=True, null=True)
    validate = models.DateField(blank=True, null=True)
    server = models.CharField(max_length=255, blank=True, null=True)
    number = models.CharField(max_length=255, blank=True, null=True)
    password = models.CharField(max_length=255, blank=True, null=True)
    nickname = models.CharField(max_length=255, blank=True, null=True)
    user = models.ForeignKey("Users", models.DO_NOTHING)
    created_at = models.DateTimeField(blank=True, null=True)
    updated_at = models.DateTimeField(blank=True, null=True)
    initial_balance = models.DecimalField(
        max_digits=10, decimal_places=2, blank=True, null=True
    )

    class Meta:
        managed = False
        db_table = "fbs_licenses"

    def __str__(self):
        return (
            f"FBS License {self.nickname} - Status: {self.status_license}"
            if self.nickname
            else "FBS License Entry"
        )


class FormFields(models.Model):
    id = models.BigAutoField(primary_key=True)
    uuid = models.CharField(max_length=36)
    form = models.ForeignKey("Forms", models.DO_NOTHING)
    label = models.CharField(max_length=255)
    name = models.CharField(max_length=255)
    type = models.CharField(max_length=255)
    required = models.IntegerField()
    options = models.JSONField(blank=True, null=True)
    order = models.IntegerField()
    created_at = models.DateTimeField(blank=True, null=True)
    updated_at = models.DateTimeField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = "form_fields"

    def __str__(self):
        return (
            f"Form Field {self.label} ({self.name}) - Type: {self.type}"
            if self.label
            else "Form Field Entry"
        )


class Forms(models.Model):
    id = models.BigAutoField(primary_key=True)
    name = models.CharField(max_length=255)
    created_at = models.DateTimeField(blank=True, null=True)
    updated_at = models.DateTimeField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = "forms"

    def __str__(self):
        return self.name if self.name else "Form Entry"


class Images(models.Model):
    id = models.BigAutoField(primary_key=True)
    image = models.CharField(unique=True, max_length=255)
    item_id = models.PositiveBigIntegerField(blank=True, null=True)
    token = models.CharField(max_length=256, blank=True, null=True)
    type = models.CharField(max_length=100, blank=True, null=True)
    created_at = models.DateTimeField(blank=True, null=True)
    updated_at = models.DateTimeField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = "images"

    def __str__(self):
        return self.image if self.image else "Image Entry"


class Migrations(models.Model):
    migration = models.CharField(max_length=255)
    batch = models.IntegerField()

    class Meta:
        managed = False
        db_table = "migrations"

    def __str__(self):
        return (
            f"Migration {self.migration} - Batch {self.batch}"
            if self.migration
            else "Migration Entry"
        )


class ModelHasPermissions(models.Model):
    pk = models.CompositePrimaryKey("permission_id", "model_id", "model_type")
    permission = models.ForeignKey("Permissions", models.DO_NOTHING)
    model_type = models.CharField(max_length=255)
    model_id = models.PositiveBigIntegerField()

    class Meta:
        managed = False
        db_table = "model_has_permissions"

    def __str__(self):
        return (
            f"Model Permission {self.permission.name} for {self.model_type} ID {self.model_id}"
            if self.permission
            else "Model Permission Entry"
        )


class ModelHasRoles(models.Model):
    pk = models.CompositePrimaryKey("role_id", "model_id", "model_type")
    role = models.ForeignKey("Roles", models.DO_NOTHING)
    model_type = models.CharField(max_length=255)
    model_id = models.PositiveBigIntegerField()

    class Meta:
        managed = False
        db_table = "model_has_roles"

    def __str__(self):
        return (
            f"Model Role {self.role.name} for {self.model_type} ID {self.model_id}"
            if self.role
            else "Model Role Entry"
        )


class Notifications(models.Model):
    id = models.CharField(primary_key=True, max_length=36)
    type = models.CharField(max_length=255)
    notifiable_type = models.CharField(max_length=255)
    notifiable_id = models.PositiveBigIntegerField()
    data = models.TextField()
    read_at = models.DateTimeField(blank=True, null=True)
    created_at = models.DateTimeField(blank=True, null=True)
    updated_at = models.DateTimeField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = "notifications"

    def __str__(self):
        return (
            f"Notification {self.id} - Type: {self.type} for {self.notifiable_type} ID {self.notifiable_id}"
            if self.id
            else "Notification Entry"
        )


class PasswordResetTokens(models.Model):
    email = models.CharField(primary_key=True, max_length=255)
    token = models.CharField(max_length=255)
    created_at = models.DateTimeField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = "password_reset_tokens"

    def __str__(self):
        return (
            f"Password Reset Token for {self.email}"
            if self.email
            else "Password Reset Token Entry"
        )


class Permissions(models.Model):
    id = models.BigAutoField(primary_key=True)
    name = models.CharField(max_length=255)
    guard_name = models.CharField(max_length=255)
    created_at = models.DateTimeField(blank=True, null=True)
    updated_at = models.DateTimeField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = "permissions"
        unique_together = (("name", "guard_name"),)

    def __str__(self):
        return self.name if self.name else "Permission Entry"


class PersonalAccessTokens(models.Model):
    id = models.BigAutoField(primary_key=True)
    tokenable_type = models.CharField(max_length=255)
    tokenable_id = models.PositiveBigIntegerField()
    name = models.CharField(max_length=255)
    token = models.CharField(unique=True, max_length=64)
    abilities = models.TextField(blank=True, null=True)
    last_used_at = models.DateTimeField(blank=True, null=True)
    expires_at = models.DateTimeField(blank=True, null=True)
    created_at = models.DateTimeField(blank=True, null=True)
    updated_at = models.DateTimeField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = "personal_access_tokens"

    def __str__(self):
        return (
            f"Personal Access Token {self.name} for {self.tokenable_type} ID {self.tokenable_id}"
            if self.name
            else "Personal Access Token Entry"
        )


class RoleHasPermissions(models.Model):
    pk = models.CompositePrimaryKey("permission_id", "role_id")
    permission = models.ForeignKey(Permissions, models.DO_NOTHING)
    role = models.ForeignKey("Roles", models.DO_NOTHING)

    class Meta:
        managed = False
        db_table = "role_has_permissions"

    def __str__(self):
        return (
            f"Role Permission {self.permission.name} for Role {self.role.name}"
            if self.permission and self.role
            else "Role Permission Entry"
        )


class Roles(models.Model):
    id = models.BigAutoField(primary_key=True)
    name = models.CharField(max_length=255)
    guard_name = models.CharField(max_length=255)
    created_at = models.DateTimeField(blank=True, null=True)
    updated_at = models.DateTimeField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = "roles"
        unique_together = (("name", "guard_name"),)

    def __str__(self):
        return self.name if self.name else "Role Entry"


class Sessions(models.Model):
    id = models.CharField(primary_key=True, max_length=255)
    user_id = models.PositiveBigIntegerField(blank=True, null=True)
    ip_address = models.CharField(max_length=45, blank=True, null=True)
    user_agent = models.TextField(blank=True, null=True)
    payload = models.TextField()
    last_activity = models.IntegerField()

    class Meta:
        managed = False
        db_table = "sessions"

    def __str__(self):
        return (
            f"Session {self.id} for User ID {self.user_id}"
            if self.id
            else "Session Entry"
        )


class Users(models.Model):
    id = models.BigAutoField(primary_key=True)
    name = models.CharField(max_length=255)
    email = models.CharField(unique=True, max_length=255)
    email_verified_at = models.DateTimeField(blank=True, null=True)
    password = models.CharField(max_length=255)
    two_factor_secret = models.TextField(blank=True, null=True)
    two_factor_recovery_codes = models.TextField(blank=True, null=True)
    two_factor_confirmed_at = models.DateTimeField(blank=True, null=True)
    status = models.IntegerField(blank=True, null=True)
    role = models.CharField(max_length=255)
    remember_token = models.CharField(max_length=100, blank=True, null=True)
    current_team_id = models.PositiveBigIntegerField(blank=True, null=True)
    profile_photo_path = models.CharField(max_length=2048, blank=True, null=True)
    created_at = models.DateTimeField(blank=True, null=True)
    updated_at = models.DateTimeField(blank=True, null=True)
    tel = models.CharField(max_length=255, blank=True, null=True)
    profile = models.CharField(max_length=255, blank=True, null=True)
    name_trader = models.CharField(max_length=255, blank=True, null=True)
    confirmed = models.IntegerField(blank=True, null=True)
    address = models.CharField(max_length=255, blank=True, null=True)
    zipcode = models.CharField(max_length=255, blank=True, null=True)
    city = models.CharField(max_length=255, blank=True, null=True)
    state = models.CharField(max_length=255, blank=True, null=True)
    doc_number = models.CharField(max_length=255, blank=True, null=True)
    amount = models.DecimalField(max_digits=10, decimal_places=2, blank=True, null=True)
    date_of_birth = models.DateField(blank=True, null=True)
    license_validity = models.DateField(blank=True, null=True)
    status_license = models.IntegerField(blank=True, null=True)
    fbs_server = models.CharField(max_length=255, blank=True, null=True)
    fbs_account = models.CharField(max_length=255, blank=True, null=True)
    fbs_password = models.CharField(max_length=255, blank=True, null=True)
    app_login = models.CharField(max_length=255, blank=True, null=True)
    app_password = models.CharField(max_length=255, blank=True, null=True)
    enables_app_order_closure = models.IntegerField(blank=True, null=True)
    initial_investment = models.DecimalField(
        max_digits=10, decimal_places=2, blank=True, null=True
    )
    currency = models.CharField(max_length=20, blank=True, null=True)
    number = models.CharField(max_length=15, blank=True, null=True)
    first_save = models.IntegerField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = "users"

    def __str__(self):
        return self.name if self.name else self.email
