<?php
header('Content-Type: application/json');

$method = $_SERVER['REQUEST_METHOD'];
$path = $_SERVER['REQUEST_URI'];

if ($method === 'GET' && ($path === '/' || $path === '/index.php')) {
    echo json_encode(['status' => 'API online']);
    exit;
}

if ($method === 'POST' && preg_match('#^/api/v1/dados$#', $path)) {
    $json = file_get_contents('php://input');

    // Adiciona data ao log
    $logEntry = date('Y-m-d H:i:s') . ' | ' . $json . PHP_EOL;
    file_put_contents("log_json_mt4.txt", $logEntry, FILE_APPEND);

    $data = json_decode($json, true);

    if (!$data || !isset($data['numeroConta'])) {
        http_response_code(400);
        echo json_encode(['error' => 'JSON inválido ou incompleto']);
        exit;
    }

    // Conexão com o MySQL
    $servername = "localhost";
    $username = "wwrbst_rbs_mt4trader";
    $password = "RBs@2025#";
    $dbname = "wwrbst_rbs_mt4trader";

    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro de conexão com o banco: ' . $conn->connect_error]);
        exit;
    }

    // Verifica se já existe a conta
    $stmtCheck = $conn->prepare("SELECT id FROM dados_conta WHERE numero_conta = ?");
    $stmtCheck->bind_param("s", $data['numeroConta']);
    $stmtCheck->execute();
    $stmtCheck->store_result();

    // Sanitização dos dados
    $nomeConta     = $data['nomeConta'];
    $numeroConta   = $data['numeroConta'];
    $saldoBruto    = isset($data['saldoBruto']) ? floatval($data['saldoBruto']) : 0.0;
    $saldoLiquido  = isset($data['saldoLiquido']) ? floatval($data['saldoLiquido']) : 0.0;
    $saldoAberto   = isset($data['saldoAberto']) ? floatval($data['saldoAberto']) : 0.0;
    $ordensAbertas = isset($data['ordensAbertas']) ? intval($data['ordensAbertas']) : 0;

    if ($stmtCheck->num_rows > 0) {
        // UPDATE
        $stmtCheck->bind_result($idConta);
        $stmtCheck->fetch();

        $stmtUpdate = $conn->prepare("UPDATE dados_conta SET 
            nome_conta = ?, saldo_bruto = ?, saldo_liquido = ?, saldo_aberto = ?, ordens_abertas = ? WHERE id = ?");
        $stmtUpdate->bind_param("sddddi", $nomeConta, $saldoBruto, $saldoLiquido, $saldoAberto, $ordensAbertas, $idConta);
        $stmtUpdate->execute();
        $stmtUpdate->close();

    } else {
        // INSERT
        $stmtInsert = $conn->prepare("INSERT INTO dados_conta 
            (nome_conta, numero_conta, saldo_bruto, saldo_liquido, saldo_aberto, ordens_abertas) 
            VALUES (?, ?, ?, ?, ?, ?)");
        $stmtInsert->bind_param("ssdddd", $nomeConta, $numeroConta, $saldoBruto, $saldoLiquido, $saldoAberto, $ordensAbertas);
        $stmtInsert->execute();
        $idConta = $stmtInsert->insert_id;
        $stmtInsert->close();
    }

    $stmtCheck->close();

    // Inserir ordens encerradas (se houver)
    if (!empty($data['ordensEncerradas']) && is_array($data['ordensEncerradas'])) {
        $stmtOrdem = $conn->prepare("INSERT INTO ordem_encerrada (dados_conta_id, ordem_ticket, ordem_lucro) 
                                     VALUES (?, ?, ?)");

        foreach ($data['ordensEncerradas'] as $ordem) {
            $ordemTicket = $ordem['ordemTicket'];
            $ordemLucro = isset($ordem['ordemLucro']) ? floatval($ordem['ordemLucro']) : 0.0;

            $stmtOrdem->bind_param("isd", $idConta, $ordemTicket, $ordemLucro);
            $stmtOrdem->execute();
        }
        $stmtOrdem->close();
    }

    $conn->close();

    echo json_encode(['success' => true, 'mensagem' => 'Dados salvos ou atualizados com sucesso']);
    exit;
}

http_response_code(404);
echo json_encode(['error' => 'Endpoint não encontrado']);
