<?php
require_once 'database.php'; // Sua função getConnection()

header('Content-Type: application/json');

$method = $_SERVER['REQUEST_METHOD'];
$path = $_SERVER['REQUEST_URI'];

// ENDPOINT simples de status
if ($method === 'GET' && ($path === '/' || $path === '/index.php')) {
    echo json_encode(['status' => 'API online']);
    exit;
}

// ENDPOINT para receber JSON
if ($method === 'POST' && preg_match('#^/api/v1/dados$#', $path)) {
    $json = file_get_contents('php://input');

    // Adiciona data ao log
    $logEntry = date('Y-m-d H:i:s') . ' | ' . $json . PHP_EOL;
    file_put_contents("log_mt4.txt", $logEntry, FILE_APPEND);

    $data = json_decode($json, true);

    if (!$data || !isset($data['numeroConta'])) {
        http_response_code(400);
        echo json_encode(['error' => 'JSON inválido ou incompleto']);
        exit;
    }

    echo json_encode(['status' => 'JSON recebido']);
    
    // Prossegue para processar após resposta
    processaLog();
    exit;
}

// Função para ler o log e processar os dados
function processaLog() {
    $logPath = '/home/wwrbst/robot-api.rbstrader.com/log_mt4.txt';

    if (!file_exists($logPath)) {
        file_put_contents("/home/wwrbst/robot-api.rbstrader.com/logs/erros_processar_logs.log", 
            date('Y-m-d H:i:s') . " | Arquivo de log não encontrado: $logPath" . PHP_EOL, FILE_APPEND);
        return;
    }

    $linhas = file($logPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $ultimasLinhas = array_slice($linhas, -2);

    $pdo = getConnection();

    foreach ($ultimasLinhas as $linha) {
        [$dataHora, $jsonString] = explode(' | ', $linha, 2);
        $data = json_decode(trim($jsonString), true);

        if (!$data || !isset($data['numeroConta'])) {
            continue;
        }

        $saldoBruto = round($data['saldoBruto'], 2);
        $saldoLiquido = round($data['saldoLiquido'], 2);
        $saldoAberto = round($data['saldoAberto'], 2);

        try {
            $sqlCheck = "SELECT id FROM dados_conta WHERE numero_conta = :numeroConta LIMIT 1";
            $stmt = $pdo->prepare($sqlCheck);
            $stmt->execute([':numeroConta' => $data['numeroConta']]);
            $contaExistente = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($contaExistente) {
                $sql = "UPDATE dados_conta SET
                            nome_conta = :nomeConta,
                            saldo_bruto = :saldoBruto,
                            saldo_liquido = :saldoLiquido,
                            saldo_aberto = :saldoAberto,
                            ordens_abertas = :ordensAbertas
                        WHERE id = :id";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([
                    ':nomeConta' => $data['nomeConta'],
                    ':saldoBruto' => $saldoBruto,
                    ':saldoLiquido' => $saldoLiquido,
                    ':saldoAberto' => $saldoAberto,
                    ':ordensAbertas' => $data['ordensAbertas'],
                    ':id' => $contaExistente['id']
                ]);
                $contaId = $contaExistente['id'];
            } else {
                $sql = "INSERT INTO dados_conta (nome_conta, numero_conta, saldo_bruto, saldo_liquido, saldo_aberto, ordens_abertas)
                        VALUES (:nomeConta, :numeroConta, :saldoBruto, :saldoLiquido, :saldoAberto, :ordensAbertas)";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([
                    ':nomeConta' => $data['nomeConta'],
                    ':numeroConta' => $data['numeroConta'],
                    ':saldoBruto' => $saldoBruto,
                    ':saldoLiquido' => $saldoLiquido,
                    ':saldoAberto' => $saldoAberto,
                    ':ordensAbertas' => $data['ordensAbertas']
                ]);
                $contaId = $pdo->lastInsertId();
            }

            if (!empty($data['ordensEncerradas'])) {
                foreach ($data['ordensEncerradas'] as $ordem) {
                    $ordemLucro = round($ordem['ordemLucro'], 2);
                    $sqlOrdem = "INSERT INTO ordem_encerrada (dados_conta_id, ordem_ticket, ordem_lucro)
                                 VALUES (:dados_conta_id, :ordem_ticket, :ordem_lucro)";
                    $stmt = $pdo->prepare($sqlOrdem);
                    $stmt->execute([
                        ':dados_conta_id' => $contaId,
                        ':ordem_ticket' => $ordem['ordemTicket'],
                        ':ordem_lucro' => $ordemLucro
                    ]);
                }
            }

        } catch (Exception $e) {
            file_put_contents("/home/wwrbst/robot-api.rbstrader.com/logs/erros_processar_logs.log", 
                date('Y-m-d H:i:s') . ' | Erro ao processar JSON: ' . $e->getMessage() . PHP_EOL, FILE_APPEND);
        }
    }

    // Apaga o arquivo
    unlink($logPath);
}

http_response_code(404);
echo json_encode(['error' => 'Endpoint não encontrado']);
